#ifndef _NEWPASSDLG_CPP
#define _NEWPASSDLG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <ShlObj.H>
#include <Stdio.H>
#include <ShlOBJ.H>
#include <Stdlib.H>

#include "../Resources/Resource.H"

#include "../Source/NSWFL.H"
#include "../Source/Package.H"
#include "../Source/Entry.H"
#include "../Source/Common.H"
#include "../Source/FolderTree.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/NewPassDlg.H"
#include "../Dialogs/OpenPassDlg.H"
#include "../Dialogs/NewFolderDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND NewPassDialog_hWnd = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK NewPassDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static FolderTree MyFolderTree;

    static HMENU SystemMenu = NULL;

    static HWND BrowseTree_hWnd = NULL;
    static HWND Password1_hWnd = NULL;
    static HWND Password2_hWnd = NULL;
    static HWND PasswordBits_hWnd = NULL;
    static HWND PasswordBitsBar_hWnd = NULL;
    static HWND SaveToLocation_hWnd = NULL;
    static HWND SaveToFile_hWnd = NULL;
    static HWND CompressLevel_hWnd = NULL;
    static HWND EncryptAlgo_hWnd = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        NewPassDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        Password1_hWnd = GetDlgItem(xHandle, IDC_PASSWORD1);
        Password2_hWnd = GetDlgItem(xHandle, IDC_PASSWORD2);
        PasswordBitsBar_hWnd = GetDlgItem(xHandle, IDC_PASSWORDBAR2);
        PasswordBits_hWnd = GetDlgItem(xHandle, IDC_PASSWORDBITS2);
        SaveToLocation_hWnd = GetDlgItem(xHandle, IDC_SAVETOLOCATION);
        SaveToFile_hWnd = GetDlgItem(xHandle, IDC_SAVETOFILE);
        CompressLevel_hWnd = GetDlgItem(xHandle, IDC_COMPRESSLEVEL);
        EncryptAlgo_hWnd = GetDlgItem(xHandle, IDC_ENCRYPTALGO);
        BrowseTree_hWnd = GetDlgItem(xHandle, IDC_BROWSETREE);

        SendMessage(Password1_hWnd, EM_LIMITTEXT, 1024, 0 );
        SendMessage(Password2_hWnd, EM_LIMITTEXT, 1024, 0 );

        int iIndex = 0;

        SendMessage(CompressLevel_hWnd, (UINT)CB_ADDSTRING, (WPARAM)0, (LPARAM)"None");
        SendMessage(CompressLevel_hWnd, (UINT)CB_ADDSTRING, (WPARAM)0, (LPARAM)"Very Low (Default)");
        SendMessage(CompressLevel_hWnd, (UINT)CB_ADDSTRING, (WPARAM)0, (LPARAM)"Low");
        SendMessage(CompressLevel_hWnd, (UINT)CB_ADDSTRING, (WPARAM)0, (LPARAM)"Moderate");
        SendMessage(CompressLevel_hWnd, (UINT)CB_ADDSTRING, (WPARAM)0, (LPARAM)"High");
        SendMessage(CompressLevel_hWnd, (UINT)CB_ADDSTRING, (WPARAM)0, (LPARAM)"Very High (Slowest)");
        iIndex = SendMessage(CompressLevel_hWnd, (UINT)CB_FINDSTRING, (WPARAM)-1, (LPARAM)"Very Low (Default)");
		//iIndex = SendMessage(CompressLevel_hWnd, (UINT)CB_FINDSTRING, (WPARAM)-1, (LPARAM)"None");
        SendMessage(CompressLevel_hWnd, (UINT)CB_SETCURSEL, (WPARAM)iIndex, (LPARAM)NULL);

        SendMessage(EncryptAlgo_hWnd, (UINT)CB_ADDSTRING, (WPARAM)0, (LPARAM)"AES Algorithm (Rijndael)");
        SendMessage(EncryptAlgo_hWnd, (UINT)CB_ADDSTRING, (WPARAM)0, (LPARAM)"NASCCL");
        SendMessage(EncryptAlgo_hWnd, (UINT)CB_ADDSTRING, (WPARAM)0, (LPARAM)"BlowFish");
        //SendMessage(EncryptAlgo_hWnd, (UINT)CB_ADDSTRING, (WPARAM)0, (LPARAM)"Tripple-DES");
        //SendMessage(EncryptAlgo_hWnd, (UINT)CB_ADDSTRING, (WPARAM)0, (LPARAM)"Serpent");
        iIndex = SendMessage(EncryptAlgo_hWnd, (UINT)CB_FINDSTRING, (WPARAM)-1, (LPARAM)"NASCCL");
        SendMessage(EncryptAlgo_hWnd, (UINT)CB_SETCURSEL, (WPARAM)iIndex, (LPARAM)NULL);

		
		if(giPkgAttribs &ATTRIB_DATETIME)
        {
            CheckDlgButton(xHandle, IDC_CHKTIMESTAMPS, BST_CHECKED);
        }

        if(giPkgAttribs &ATTRIB_ATTRIBUTES)
        {
            CheckDlgButton(xHandle, IDC_CHKATTRIBUTES, BST_CHECKED);
        }

        if(giPkgAttribs &ATTRIB_CRCCHECK)
        {
            CheckDlgButton(xHandle, IDC_CHKCRCS, BST_CHECKED);
        }

        if(gdwCurrentJobType == JOB_TYPE_PACKING_FIL)
		{
			CheckDlgButton(xHandle, IDC_CHKSAVEPATHS, BST_UNCHECKED);
			EnableWindow(GetDlgItem(xHandle, IDC_CHKSAVEPATHS), FALSE);
		}
		else if(giPkgAttribs &ATTRIB_SAVEPATHS)
        {
            CheckDlgButton(xHandle, IDC_CHKSAVEPATHS, BST_CHECKED);
        }

        Set_Text(Password1_hWnd, "9e8t49e8rt4389476i516se56");
        Set_Text(Password2_hWnd, "9e8t49e8rt4389476i516se56");

        MyFolderTree.InitFolderTree(BrowseTree_hWnd, GetDlgItem(xHandle, IDC_ENCRYPT), SaveToLocation_hWnd);

        char FullPath[MAX_PATH + 1];
        char Drive[MAX_PATH + 1];
        char Dir[MAX_PATH + 1];
        char File[MAX_PATH + 1];

        if(IsDirectory(gsArchiveName))
        {
            int Length = strlen(gsArchiveName);

            if(gsArchiveName[Length - 1] == '\\')
            {
                gsArchiveName[Length] = '\0';
            }

            _splitpath(gsArchiveName, Drive, Dir, File, NULL);
            _makepath(FullPath, Drive, Dir, NULL, NULL);
            MyFolderTree.SelectPath(FullPath);

            _makepath(FullPath, NULL, NULL, File, ".pce");
            Set_Text(SaveToFile_hWnd, FullPath);
        }
        else {
            // Parse file name and location
            _splitpath(gsArchiveName, Drive, Dir, File, NULL);
            _makepath(FullPath, Drive, Dir, NULL, NULL);
            MyFolderTree.SelectPath(FullPath);

			_makepath(FullPath, NULL, NULL, File, ".pce");
            Set_Text(SaveToFile_hWnd, FullPath);
        }

        CenterWindow(xHandle);

        return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(MyFolderTree.FolderTreeHandler(xHandle, xMessage, wParam, lParam))
    {
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == 307) // Key Down
    {
        float PasswordLen1   = 0;
        float PasswordLen2    = 0;
        float EffeciencyBits = 0;

        char lsTemp0[64];
        char lsTemp1[64];

        PasswordLen1 = (float) SendMessage(Password1_hWnd, WM_GETTEXTLENGTH, 0, 0);
        PasswordLen2 = (float) SendMessage(Password2_hWnd, WM_GETTEXTLENGTH, 0, 0);

        HWND CurrentFocus = GetFocus();

        if(CurrentFocus == Password1_hWnd)
        {
            EffeciencyBits = (PasswordLen1 / 56) * 100;
            SendMessage(PasswordBitsBar_hWnd, PBM_SETPOS, (int) EffeciencyBits, 0);

            sprintf(lsTemp0," (%s Bits)", FormatInteger(lsTemp1, ((long)PasswordLen1 * 8)));
            Set_Text(PasswordBits_hWnd, lsTemp0);
        }
        else if(CurrentFocus == Password2_hWnd)
        {
            EffeciencyBits = (PasswordLen2 / 56) * 100;
            SendMessage(PasswordBitsBar_hWnd, PBM_SETPOS, (int) EffeciencyBits, 0);

            sprintf(lsTemp0," (%s Bits)", FormatInteger(lsTemp1, ((long)PasswordLen2 * 8)));
            Set_Text(PasswordBits_hWnd, lsTemp0);
        }
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
		if(wParam == IDC_NEWFOLDER)
        {
            int Length = Get_TextEx(SaveToLocation_hWnd, gsExtractLocation, 255);
			if(Length > 0 || Length <= 255)
			{
				if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_NEWFOLDER), xHandle, NewFolderDialog) == 1)
				{
					char sNewPath[MAX_PATH + 1];
					_makepath(sNewPath, NULL, gsExtractLocation, sNewFolderName, NULL);
					strcat(sNewPath, "\\");
					CreateFolderStructure(sNewPath);

					//This is a bad way to refresh the treview.
					MyFolderTree.UnInitFolderTree();
					MyFolderTree.InitFolderTree(BrowseTree_hWnd, GetDlgItem(xHandle, IDC_EXTRACT), SaveToLocation_hWnd);
					MyFolderTree.SelectPath(sNewPath);
				}
			}
			return TRUE;
		}

		if(wParam == IDC_GOTO)
        {
            int Length = Get_TextEx(SaveToLocation_hWnd, gsExtractLocation, 255);
			if(Length > 0 || Length <= 255)
			{
				MyFolderTree.SelectPath(gsExtractLocation);
			}
			return TRUE;
		}

		if(wParam == IDC_ENCRYPT)
        {

            char lsPassword1[1024 + 1];
            char lsPassword2[1024 + 1];
            char lsCompressLevel[32 + 1];
			char lsEncryptionMethod[32 + 1];

            int Length1 = Get_TextEx(Password1_hWnd, lsPassword1, 1024);
            int Length2 = Get_TextEx(Password2_hWnd, lsPassword2, 1024);

            if((Length1 < 8 || Length1 > 1024) || (Length2 < 8 || Length2 > 1024))
            {
                MessageBox(xHandle, "Please enter the same password twice. Within 8 and 1,024 characters.", gsTitleCaption, 0);
                return TRUE;
            }

            if(strcmp(lsPassword1, lsPassword2) != 0)
            {
                MessageBox(xHandle, "The passwords you entered do not match.", gsTitleCaption, 0);
                return TRUE;
            }

            char SaveToLocation[MAX_PATH + 1];
            char SaveToFile[MAX_PATH + 1];

            Length1 = Get_TextEx(SaveToLocation_hWnd, SaveToLocation, MAX_PATH);
            Length2 = Get_TextEx(SaveToFile_hWnd, SaveToFile, MAX_PATH);

            if(SaveToFile[0] == '\\' || SaveToFile[0] == '/')
            {
                int Len = strlen(SaveToLocation);
                if(SaveToLocation[Len - 1] == '\\' || SaveToLocation[Len - 1] == '/')
                {
                    SaveToLocation[Len - 1] = '\0';
                }
                strcat(SaveToLocation, SaveToFile);
            }
            else{
                int Len = strlen(SaveToLocation);
                if(SaveToLocation[Len - 1] != '\\' && SaveToLocation[Len - 1] != '/')
                {
                    strcat(SaveToLocation, "\\");;
                }
                strcat(SaveToLocation, SaveToFile);
            }

            strcpy(gsPassword, lsPassword1);
            strcpy(gsWorkingOutput, SaveToLocation);

            giPkgAttribs = 0;

            Get_TextEx(CompressLevel_hWnd, lsCompressLevel, 32);
            if(strcmpi(lsCompressLevel, "none") != 0)
            {
                giPkgAttribs = giPkgAttribs | ATTRIB_COMPRESSION;
                if(strcmpi(lsCompressLevel, "Very Low (Default)") == 0)
                    giCompressLevel = 0;
                else if(strcmpi(lsCompressLevel, "Low") == 0)
                    giCompressLevel = 1;
                else if(strcmpi(lsCompressLevel, "Moderate") == 0)
                    giCompressLevel = 2;
                else if(strcmpi(lsCompressLevel, "High") == 0)
                    giCompressLevel = 3;
                else if(strcmpi(lsCompressLevel, "Very High (Slowest)") == 0)
                    giCompressLevel = 4;
            }

            Get_TextEx(EncryptAlgo_hWnd, lsEncryptionMethod, 32);
			if(strcmpi(lsEncryptionMethod, "none") != 0)
            {
                if(strcmpi(lsEncryptionMethod, "NASCCL") == 0)
				{
                    giCryptAlgo = CRYPT_ALGO_NASCCL;
				}
				else if(strcmpi(lsEncryptionMethod, "AES Algorithm (Rijndael)") == 0){

                    giCryptAlgo = CRYPT_ALGO_RIJNDAEL;
				}
				else if(strcmpi(lsEncryptionMethod, "BlowFish") == 0){
                    giCryptAlgo = CRYPT_ALGO_BLOWFISH;
				}
            }

			if(IsDlgButtonChecked(xHandle, IDC_CHKTIMESTAMPS))
                giPkgAttribs = giPkgAttribs | ATTRIB_DATETIME;

            if(IsDlgButtonChecked(xHandle, IDC_CHKATTRIBUTES))
                giPkgAttribs = giPkgAttribs | ATTRIB_ATTRIBUTES;

            if(IsDlgButtonChecked(xHandle, IDC_CHKCRCS))
                giPkgAttribs = giPkgAttribs | ATTRIB_CRCCHECK;

            if(IsDlgButtonChecked(xHandle, IDC_CHKSAVEPATHS))
                giPkgAttribs = giPkgAttribs | ATTRIB_SAVEPATHS;

            MyFolderTree.UnInitFolderTree();
            EndDialog(xHandle, 1);
            return TRUE;
        }

        if(wParam == IDC_CANCEL)
        {
            MyFolderTree.UnInitFolderTree();
        	EndDialog(xHandle, 0);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(xHandle, 0);
        MyFolderTree.UnInitFolderTree();
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

